// Fill out your copyright notice in the Description page of Project Settings.


#include "EnemyMeleeCharacter.h"

// Sets default values
AEnemyMeleeCharacter::AEnemyMeleeCharacter()
{
 	// Set this character to call Tick() every frame.  You can turn this off to improve performance if you don't need it.
	PrimaryActorTick.bCanEverTick = true;



}

// Called when the game starts or when spawned
void AEnemyMeleeCharacter::BeginPlay()
{
	Super::BeginPlay();

	bUseControllerRotationPitch = false;
	bUseControllerRotationYaw = false;
	bUseControllerRotationRoll = false;

	GetCharacterMovement()->bOrientRotationToMovement = true;
	GetCharacterMovement()->RotationRate = FRotator(0.0f, 500.0f, 0.0f);

	GetCharacterMovement()->MaxWalkSpeed = 350.f;
	GetCharacterMovement()->MinAnalogWalkSpeed = 20.f;

	CapsuleComponent = GetCapsuleComponent();
	CapsuleComponent->OnComponentBeginOverlap.AddDynamic(this, &AEnemyMeleeCharacter::OnOverlapBegin);
}

// Called every frame
void AEnemyMeleeCharacter::Tick(float DeltaTime)
{
	Super::Tick(DeltaTime);

	FVector PlayerLocation = GetWorld()->GetFirstPlayerController()->GetPawn()->GetActorLocation();
	FVector DirectionToPlayer = PlayerLocation - GetActorLocation();
	
	//AddActorWorldOffset(-DirectionToPlayer * MoveSpeed);
	AddMovementInput(DirectionToPlayer, MoveSpeed);
}

// Called to bind functionality to input
//void AEnemyMeleeCharacter::SetupPlayerInputComponent(UInputComponent* PlayerInputComponent)
//{
//	Super::SetupPlayerInputComponent(PlayerInputComponent);
//
//}

void AEnemyMeleeCharacter::TakeDamage(float Damage)
{
	Health -= Damage;
	if (Health <= 0.f)
	{
		FTransform SpawnLocationTransform = GetTransform();
		FVector NewSpawnLoc = FVector(SpawnLocationTransform.GetLocation().X, SpawnLocationTransform.GetLocation().Y, FloatingZ);
		SpawnLocationTransform.SetLocation(NewSpawnLoc);
		FActorSpawnParameters SpawnInfo = FActorSpawnParameters();

		int DiceRoller = FMath::RandRange(1, 10);

		if (DiceRoller <= 3)
		{
			int CoinFlip = FMath::RandRange(1, 10);
			if (CoinFlip <= 5)
			{
				AAmmoCrate* NewAmmoCrate = GetWorld()->SpawnActor<AAmmoCrate>(AmmoCratePrimary, SpawnLocationTransform, SpawnInfo);
				NewAmmoCrate->bIsPrimary = true;
				NewAmmoCrate->bIsAxeAmmo = false;
			}
			else
			{
				AAmmoCrate* NewAmmoCrate = GetWorld()->SpawnActor<AAmmoCrate>(AmmoCrateAxe, SpawnLocationTransform, SpawnInfo);
				NewAmmoCrate->bIsPrimary = false;
				NewAmmoCrate->bIsAxeAmmo = true;
			}
		}

		Destroy();
	}
}


float AEnemyMeleeCharacter::GetDamageDeal()
{
	return DamageDeal;
}

void AEnemyMeleeCharacter::OnOverlapBegin(UPrimitiveComponent* OverlappedComp, AActor* OtherActor, UPrimitiveComponent* OtherComp, int32 OtherBodyIndex, bool bFromSweep, const FHitResult& SweepResult)
{
	if (OtherActor != nullptr)
	{
		APlayerCharacter* PlayerCharacter = Cast<APlayerCharacter>(OtherActor);

		if (PlayerCharacter)
		{
			PlayerCharacter->TakeDamage(DamageDeal, this);
		}
	}
}

