// Fill out your copyright notice in the Description page of Project Settings.

#pragma once

#include "CoreMinimal.h"
#include "GameFramework/Character.h"

#include "GameFramework/PlayerController.h"
#include "Components/CapsuleComponent.h"

#include "Engine.h"
#include "InputActionValue.h"

#include "PlayerProjectile.h"
#include "Weapon.h"
#include "PlayerHUD.h"

#include "PlayerCharacter.generated.h"



class UInputMappingContext;
class UInputAction;


UCLASS()
class SLAYTHEPREY_API APlayerCharacter : public ACharacter
{
	GENERATED_BODY()

	UPROPERTY(VisibleAnywhere, BlueprintReadOnly, Category = Camera, meta = (AllowPrivateAccess = "true"))
		class USpringArmComponent* CameraBoom;
	UPROPERTY(VisibleAnywhere, BlueprintReadOnly, Category = Camera, meta = (AllowPrivateAccess = "true"))
		class UCameraComponent* FollowCamera;

public:
	// Sets default values for this character's properties
	APlayerCharacter();

protected:
	// Called when the game starts or when spawned
	virtual void BeginPlay() override;
	

public:	
	// Called every frame
	virtual void Tick(float DeltaTime) override;

	// Called to bind functionality to input
	virtual void SetupPlayerInputComponent(class UInputComponent* PlayerInputComponent) override;
	/** Returns CameraBoom subobject **/
	FORCEINLINE class USpringArmComponent* GetCameraBoom() const { return CameraBoom; }
	/** Returns FollowCamera subobject **/
	FORCEINLINE class UCameraComponent* GetFollowCamera() const { return FollowCamera; }

	
////////////// ********* VARIABLES ********* //////////////
public:
	UPROPERTY(EditAnywhere, BlueprintReadWrite, Category = "Variables", meta = (AllowPrivateAccess = "true"))
		float MaxPlayerHealth = 100.0f;
	UPROPERTY(EditAnywhere, BlueprintReadWrite, Category = "Variables", meta = (AllowPrivateAccess = "true"))
		float PlayerHealth;
	UPROPERTY(EditAnywhere, BlueprintReadWrite, Category = "Variables", meta = (AllowPrivateAccess = "true"))
		float DodgeImpulse = 5000.0f;
	UPROPERTY(EditAnywhere, BlueprintReadWrite, Category = "Variables", meta = (AllowPrivateAccess = "true"))
		float AttackDelay = 0.2f;
	UPROPERTY(EditAnywhere, BlueprintReadWrite, Category = "Variables", meta = (AllowPrivateAccess = "true"))
		float DodgeDelay = 2.0f;
	UPROPERTY(EditAnywhere, BlueprintReadWrite, Category = "Variables", meta = (AllowPrivateAccess = "true"))
		float TakeDamageDelay = 1.0f;

	UPROPERTY(EditAnywhere, Category = "Variables for Character")
		float RotationEase = 10.f; // Higher means rotation will be more abrubt.
	UPROPERTY(EditAnywhere, Category = "Variables for Character")
		float RotationMaxSpeed = 25.f;

	


////////////// ********* WEAPONS ********* //////////////
public:
	
	enum Weapon {
		gun = 0,
		axe = 1
	};
	Weapon PlayerCurrentWeapon = gun;

	UPROPERTY(EditAnywhere, BlueprintReadWrite, Category = "Weapon Properties", meta = (AllowPrivateAccess = "true"))
	float PrimaryAmmoInMag = 40;
	UPROPERTY(EditAnywhere, BlueprintReadWrite, Category = "Weapon Properties", meta = (AllowPrivateAccess = "true"))
	float PrimaryAmmoStored = 40;
	UPROPERTY(EditAnywhere, BlueprintReadWrite, Category = "Weapon Properties", meta = (AllowPrivateAccess = "true"))
	float AxeAmmoInMag = 1;


	float AmmoMax[2] = { 40, 3 };
	float AmmoMaxStored[2] = { 320, 0 };
	float AmmoInMag[2] = { 40, 0 };
	float AmmoStored[2] = { 40, 0 };


////////////// ********* BOOLS ********* //////////////
public:
	bool bCanInteract_Axe = false;
	bool bCanTakeDamage = true;
	bool bCanMove = true;
	bool bCanAttack = true;
	bool bCanDodge = true;



////////////// ********* REFERENCES ********* //////////////
public:
	UCapsuleComponent* CapsuleComponent;
	UStaticMeshComponent* ProjectileSpawnComponent;
	UAnimSequence* Anim;

	UChildActorComponent* WeaponBackpack_Axe[3];

	UPROPERTY(EditAnywhere, BlueprintReadWrite, Category = "Variables")
		TSubclassOf<APlayerProjectile> Projectile;
	UPROPERTY(EditAnywhere, BlueprintReadWrite, Category = "Variables")
		TSubclassOf<AWeapon> Axe;

	AWeapon* AxeInteractionReference;

	UPROPERTY(EditAnywhere, Category = "Widgets")
		TSubclassOf<UUserWidget> WidgetsClass;
	void SetInteractVisibility(bool Visible);
	UInteract* UI_Interact;


////////////// ********* FUNCTIONS ********* //////////////
public:
	void ResetAttack();
	void ResetDodge();
	void ResetTakeDamage();
	void TakeDamage(float Damage, AActor* OtherActor);
	void Heal(float HealAmmount);
	void GameOver();
	void RestartGame();

	void UpdateRotationTowardsCursor(USceneComponent* Comp, float DeltaTime);

	UFUNCTION(BlueprintImplementableEvent)
	void EWhenTakesDamage();
	UFUNCTION(BlueprintImplementableEvent)
	void EWhenAttacks();

	UFUNCTION()
	void OnOverlapBegin(UPrimitiveComponent* OverlappedComp, AActor* OtherActor, UPrimitiveComponent* OtherComp, int32 OtherBodyIndex, bool bFromSweep, const FHitResult& SweepResult);
	UFUNCTION()
	void OnOverlapEnd(UPrimitiveComponent* OverlappedComp, class AActor* OtherActor, class UPrimitiveComponent* OtherComp, int32 OtherBodyIndex);
	UFUNCTION()
	void OnHit(UPrimitiveComponent* HitComponent, AActor* OtherActor, UPrimitiveComponent* OtherComp, FVector NormalImpulse, const FHitResult& Hit);


protected:
	void Move(const FInputActionValue& Value);
	void Attack();
	void Dodge();
	void Interact();
	void Reload();
	void AttackAlternative();
	void ItemSlot1();
	void ItemSlot2();
	void RotateCamera_Left();
	void RotateCamera_Right();


////////////// ********* TIMERS ********* //////////////
public:
	FTimerHandle AttackDelayTimerHandle;
	FTimerHandle DodgeDelayTimerHandle;
	FTimerHandle TakeDamageDelayTimerHandle;

////////////// ********* INPUTS ********* //////////////
protected:
	UPROPERTY(EditAnywhere, Category = Input)
	UInputMappingContext* PlayerContext;

	UPROPERTY(EditAnywhere, Category = Input)
	UInputAction* MovementAction;
	UPROPERTY(EditAnywhere, Category = Input)
	UInputAction* DodgeAction;

	UPROPERTY(EditAnywhere, Category = Input)
	UInputAction* AttackAction;
	UPROPERTY(EditAnywhere, Category = Input)
	UInputAction* AttackAlternativeAction;

	UPROPERTY(EditAnywhere, Category = Input)
	UInputAction* InteractAction;
	
	UPROPERTY(EditAnywhere, Category = Input)
	UInputAction* ItemSlot1Action;
	UPROPERTY(EditAnywhere, Category = Input)
	UInputAction* ItemSlot2Action;
	UPROPERTY(EditAnywhere, Category = Input)
	UInputAction* ReloadAction;

	UPROPERTY(EditAnywhere, Category = Input)
	UInputAction* RotateCamera_LeftAction;
	UPROPERTY(EditAnywhere, Category = Input)
	UInputAction* RotateCamera_RightAction;

};
